﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using Advent.aiDevices;

namespace Advent.Controls
{
    public partial class AI7280DigitalIO : UserControl
    {
        AI7280_CO_Simulator.DigitalIOManager DIO = null;

        public AI7280DigitalIO()
        {
            InitializeComponent();

            cbo_OutputA.Items.Clear();
            cbo_OutputB.Items.Clear();
            cbo_OutputC.Items.Clear();

            foreach (AI7280_CO_Simulator.DigitalIOManager.OutputAState S in Enum.GetValues(typeof(AI7280_CO_Simulator.DigitalIOManager.OutputAState)))
            {
                cbo_OutputA.Items.Add(S);
            }

            foreach (AI7280_CO_Simulator.DigitalIOManager.OutputBState S in Enum.GetValues(typeof(AI7280_CO_Simulator.DigitalIOManager.OutputBState)))
            {
                cbo_OutputB.Items.Add(S);
            }

            foreach (AI7280_CO_Simulator.DigitalIOManager.OutputCState S in Enum.GetValues(typeof(AI7280_CO_Simulator.DigitalIOManager.OutputCState)))
            {
                cbo_OutputC.Items.Add(S);
            }
            
            cbo_OutputA.SelectedIndex = 0;
            cbo_OutputB.SelectedIndex = 0;
            cbo_OutputC.SelectedIndex = 0;

            this.EnabledChanged += new EventHandler(AI7280DigitalIOCtrl_EnabledChanged);

        }

        void AI7280DigitalIOCtrl_EnabledChanged(object sender, EventArgs e)
        {
            timer_Update.Enabled = this.Enabled;
        }

        public void SetDigitalIO(AI7280_CO_Simulator.DigitalIOManager DIO)
        {
            this.DIO = DIO;
            RefreshControls();
        }

        private void RefreshControls()
        {
            if (DIO == null) return;
            cbo_OutputA.SelectedItem = DIO.OutputA;
            cbo_OutputB.SelectedItem = DIO.OutputB;
            cbo_OutputC.SelectedItem = DIO.OutputC;
        }

        private void timer_Update_Tick(object sender, EventArgs e)
        {
            try
            {
                if (DIO == null) return;
                Boolean[] Inputs = DIO.GetDigitalInputs();

                lbl_InputA.Text = Inputs[0].ToString();
                lbl_InputB.Text = Inputs[1].ToString();

            }
            catch { }
        }

        private void cbo_OutputA_SelectedIndexChanged(object sender, EventArgs e)
        {
            try
            {
                if (DIO == null) return;
                DIO.OutputA = (AI7280_CO_Simulator.DigitalIOManager.OutputAState) cbo_OutputA.SelectedItem;
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
            finally
            {
                RefreshControls();

            }
        }

        private void cbo_OutputB_SelectedIndexChanged(object sender, EventArgs e)
        {
            try
            {
                if (DIO == null) return;
                DIO.OutputB = (AI7280_CO_Simulator.DigitalIOManager.OutputBState)cbo_OutputB.SelectedItem;
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
            finally
            {
                RefreshControls();

            }
        }

        private void cbo_OutputC_SelectedIndexChanged(object sender, EventArgs e)
        {
            try
            {
                if (DIO == null) return;
                DIO.OutputC = (AI7280_CO_Simulator.DigitalIOManager.OutputCState)cbo_OutputC.SelectedItem;
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
            finally
            {
                RefreshControls();

            }
        }




    }
}
